/*
 * @(#)CERISAFigure.java  1.1  2006-02-21
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.cer.diagram;

import ch.hslu.cm.cer.model.ConceptualERModel;
import ch.hslu.cm.cer.model.CERISA;
import ch.hslu.cm.*;
import ch.hslu.cm.simulation.*;
import java.awt.geom.*;
import java.beans.*;
import java.io.IOException;
import java.util.*;
import javax.swing.*;
import static org.jhotdraw.draw.AttributeKeys.*;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.MoveHandle;
import org.jhotdraw.draw.locator.RelativeDecoratorLocator;
import org.jhotdraw.geom.*;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
/**
 * CERISAFigure.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.1 2006-02-21 Support for super-sub-type added.
 * <br>1.0 2006-01-18 Created.
 */
public class CERISAFigure extends TextFigure
        implements DiagramFigure, PropertyChangeListener {
    /**
     * Figure model.
     */
    private CERISA model;
    
    /** Creates a new instance. */
    public CERISAFigure() {
        ResourceBundleUtil labels = ConceptualERModel.labels;
        
        TriangleFigure decorator = new TriangleFigure(AttributeKeys.Orientation.SOUTH);
        STROKE_PLACEMENT.set(decorator, StrokePlacement.OUTSIDE);
        setDecorator(decorator);
        
        DECORATOR_INSETS.set(this, new Insets2D.Double(4,12,14,12));
        STROKE_WIDTH.set(this, ConceptualERDiagram.DIAGRAM_STROKE_WIDTH);
        
        setEditable(false);
        FONT_BOLD.set(this, false);
        FILL_COLOR.set(this, ConceptualERDiagram.ISA_FILL_COLOR);
        STROKE_COLOR.set(this, ConceptualERDiagram.ISA_STROKE_COLOR);
        TEXT_COLOR.set(this, ConceptualERDiagram.ISA_TEXT_COLOR);
        setText(labels.getString("ISA"));
        
        setModel(createISA());
        
        setAttributeEnabled(DECORATOR_INSETS, false);
        setAttributeEnabled(STROKE_TYPE, false);
        setAttributeEnabled(STROKE_PLACEMENT, false);
        setAttributeEnabled(STROKE_DASHES, false);
        setAttributeEnabled(FONT_BOLD, false);
        setAttributeEnabled(FONT_ITALIC, false);
        setAttributeEnabled(FONT_UNDERLINE, false);
    }
    // DRAWING
    
    // SHAPE AND BOUNDS
    // ATTRIBUTES
    @Override
    public void set(AttributeKey key, Object newValue) {
        super.set(key, newValue);
        if (getDecorator() != null) {
            getDecorator().set(key, newValue);
        }
    }
    // EDITING
    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            handles.add(new MoveHandle(this, RelativeDecoratorLocator.northEast()));
            handles.add(new MoveHandle(this, RelativeDecoratorLocator.northWest()));
            handles.add(new MoveHandle(this, RelativeDecoratorLocator.south()));
        }
        return handles;
    }
    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());
        
        LinkedList<Action> actions = new LinkedList<Action>();
        Action action;
        
        Figure item;
        
        
        // XXX - Implement action for toggling "disjoint" attribute.
        
        return actions;
    }
    
    
    // CONNECTING
    /**
     * Gets a connector for this figure at the given location.
     * A figure can have different connectors at different locations.
     */
    @Override public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        if (contains(p)) {
            Connector c = new CERSpecializationConnector(this);
            if (c.contains(p)) return c;
            c = new CERGeneralizationConnector(this);
            if (c.contains(p)) return c;
        }
        return null;
    }
   @Override public Connector findCompatibleConnector(Connector c, boolean isStart) {
        if (c.getOwner() == this) return c;
        if (c instanceof CERGeneralizationConnector) {
            return new CERGeneralizationConnector(this);
        } else if (c instanceof CERSpecializationConnector) {
            return new CERSpecializationConnector(this);
        }
        return null;
    }
    
    // COMPOSITE FIGURES
    // CLONING
    // EVENT HANDLING
    
    public CERISA getSimulatedEntityType() {
        return (CERISA) getModel();
    }
    
    protected CERISA createISA() {
        CERISA isa = new CERISA();
        return isa;
    }
    
    public void setModel(CERISA m) {
        willChange();
        if (model != null) {
            model.removePropertyChangeListener(this);
        }
        model = m;
        if (model != null) {
            model.addPropertyChangeListener(this);
            //setText(model.getName());
            
            updateDecorator();
        }
        changed();
    }
    
    public CERISA getModel() {
        return model;
    }
    
    private Diagram getDiagram() {
        return (Diagram) getDrawing();
    }
    private Simulation getSimulation() {
        return getDiagram().getSimulation();
    }
    
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        if ((drawing instanceof Diagram) && getModel() != null) {
            getSimulation().add(getModel());
        }
    }
    public void removeNotify(Drawing drawing) {
        if (getDrawing() != null && getModel() != null) {
            getSimulation().remove(getModel());
        }
        super.removeNotify(drawing);
    }
    
    public CERISAFigure clone() {
        CERISAFigure that = (CERISAFigure) super.clone();
        that.setModel((CERISA) this.model.clone());
        return that;
    }
    
    public SimulatedElement getSimulatedObject() {
        return model;
    }
    
    public int getConnectionCount() {
        return getModel().getRelationships().size();
    }
    
    public int getConnectionIndex(DiagramFigure f) {
        return getModel().getRelationships().indexOf(f.getModel());
    }
    
    public void read(DOMInput in) throws IOException {
        double x = in.getAttribute("x", 0d);
        double y = in.getAttribute("y", 0d);
        double w = in.getAttribute("w", 0d);
        double h = in.getAttribute("h", 0d);
        setBounds(new Point2D.Double(x,y), new Point2D.Double(x+w,y+h));
        readAttributes(in);
        in.openElement((in.getElementCount("model") == 1) ? "model" : "Model");
        setModel((CERISA) in.readObject(0));
        in.closeElement();
    }
    public void write(DOMOutput out) throws IOException {
        Rectangle2D.Double r = getBounds();
        out.addAttribute("x", r.x);
        out.addAttribute("y", r.y);
        writeAttributes(out);
        out.openElement("Model");
        out.writeObject(getModel());
        out.closeElement();
    }
    public int getLayer() {
        return ConceptualERDiagram.OBJECT_LAYER;
    }
    protected void updateDecorator() {
        // XXX - Implement me
        /*
        RectangleFigure pf = (RectangleFigure) getPresentationFigure();
        if (model != null && pf != null) {
            pf.setAttributeEnabled(STROKE_TYPE, true);
            set(STROKE_TYPE,
                    model.getType() == EntitySet.TYPE_FUNDAMENTAL ?
                        VALUE_STROKE_TYPE_BASIC :
                        VALUE_STROKE_TYPE_DOUBLE
                    );
            pf.setAttributeEnabled(STROKE_TYPE, false);
        }*/
    }
    
    public void propertyChange(PropertyChangeEvent evt) {
        willChange();
        changed();
    }
}
